//Creation tables for analysis and imputation

//1970
use "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0339.dta\enq70tab4.dta",clear
gen year=1970
//keep one observation by household
keep if nlc=="0" //keep head of household
rename qts pondn
rename mca age
rename mrt income
g homeowner=(inlist(soc2,"0","1"))
summ homeowner [aw=pondn]
rename bpl value

replace value=. if homeowner==0
summ value if homeowner==1
count if value==0 & homeowner==1
//3031/4595: 66%
g noval = (value==0)
summ noval [aw=pond] if homeowner==1
drop noval
//84%

keep year pondn age income homeow* value
save "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1970", replace


//1973
use "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0073.dta\menag73", replace
merge 1:1 nmen using "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0073.dta\propri73"
g year=1973
rename qts pondn
rename mac age
rename mrd income
g homeowner=(inlist(soc3,"1"))
summ homeowner [aw=pondn]
rename bpl value

replace value=. if homeowner==0
summ value if homeowner==1
count if value==0 & homeowner==1
//15954/20819 77%
g noval = (value==0)
summ noval [aw=pond] if homeowner==1
drop noval
//82%

keep year pondn age income homeow* value
save "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1973", replace


//1978
use "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0074.dta\menage78", replace
merge 1:1 nmen using  "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0074.dta\propri78"
g year=1978
rename qts pondn
rename mpag age
rename mrd income
g homeowner=(inlist(soc3,"1"))
summ homeowner [aw=pondn]
rename bpl value

replace value=. if homeowner==0
summ value if homeowner==1
count if value==0 & homeowner==1
// 8245/10646 77%
g noval = (value==0)
summ noval [aw=pond] if homeowner==1
drop noval
//84.7%

keep year pondn age income homeow* value
save "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1978", replace



//1984
use "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0075.dta\menage84", replace
merge 1:1 nmen using "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0075.dta\procen84"
g year=1984
rename extr pondn
rename mag age
rename mrd income
g homeowner=(inlist(soc3,"2"))
summ homeowner [aw=pondn]
rename bpl value


replace value=. if homeowner==0
summ value if homeowner==1
count if value==0 & homeowner==1
//di 1870/8775 21%
g noval = (value==0)
summ noval [aw=pond] if homeowner==1
drop noval
//9%
keep year pondn age income homeow* value
save "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1984", replace


//1988
use "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0076.dta\menage88",replace
merge 1:1 nmen using  "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0076.dta\propri88"
g year=1988
rename qex pondn
rename mag age
rename mrd income
g homeowner=(inlist(soc3,"2"))
summ homeowner [aw=pondn]
rename bpl value

replace value=. if homeowner==0
summ value if homeowner==1
count if value==0 & homeowner==1
//11519/15442 74.5%

g noval = (value==0)
summ noval [aw=pond] if homeowner==1
drop noval
//79%
keep year pondn age income homeow* value
save "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1988", replace

//1992
use "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0077.dta\admen92",replace
merge 1:1 nmen using "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0077.dta\propri92"
destring mag, replace
g year=1992
rename qex pondn
rename mag age
rename mrd income
g homeowner=(inlist(soc3,"2"))
summ homeowner [aw=pondn]
rename bpl value

replace value=. if homeowner==0
summ value if homeowner==1
count if value==0 & homeowner==1
//17208/20261
g noval = (value==0)
summ noval [aw=pond] if homeowner==1
drop noval
//87.5%

keep year pondn age income homeow* value
save "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1992", replace


//1996
use "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0078.dta\menage",replace
g year = 1996
rename qex pondn
rename mag age
rename mrtota income
g homeowner=(inlist(soc3,"2"))
summ homeowner [aw=pondn]
rename bpl value

replace value=. if homeowner==0
summ value if homeowner==1
count if value==0 & homeowner==1
//0/2358
g noval = (value==0)
summ noval [aw=pond] if homeowner==1
drop noval
//0%
rename mrsal wage
rename mrcho ui
rename mrret pension
rename mrtns nonwage
rename mrfon housing
rename mrpla nonhousingcap

keep year pondn age income homeow* value wage ui pension non* hous*
save "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1996", replace


//2002
use "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0179b.dta\Stata\menage",replace
g year = 2002
rename qex pondn
rename mag age
rename mrtota income
g homeowner=(inlist(soc3,"2"))
summ homeowner [aw=pondn]
rename bpl value

replace value=. if homeowner==0
summ value if homeowner==1
count if value==0 & homeowner==1
//0/32156  
g noval = (value==0)
summ noval [aw=pond] if homeowner==1
drop noval
//0%

rename mrsal wage
rename mrcho ui
rename mrret pension
rename mrtns nonwage
rename mrfon housing
rename mrpla nonhousingcap

keep year pondn age income homeow* value wage ui pension non* hous*
save "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl2002", replace


//2006
use "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-0410.dta\Stata\menage",replace
g year = 2006
rename qex pondn
rename mag age
rename mrtota income
g homeowner=(inlist(soc3,"2"))
summ homeowner [aw=pondn]
rename bpl value

replace value=. if homeowner==0
summ value if homeowner==1
count if value==0 & homeowner==1
//0/22368
g noval = (value==0)
summ noval [aw=pond] if homeowner==1
drop noval
//0%
rename mrsal wage
rename mrcho ui
rename mrret pension
rename mrtns nonwage
rename mrfon housing
rename mrpla nonhousingcap

keep year pondn age income homeow* value wage ui pension non* hous*
save "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl2006", replace


//2010
use "\\ulysse\users\BGarbinti\brtrd\Enquete Logements\EnquetesLogements\2016_06_07_Stata\lil-1022.dta\Stata\menlogfm_diff",replace
g year = 2010
rename qex pondn
rename mag age
rename mrtota2 income
g homeowner=(inlist(soc3,"2"))
summ homeowner [aw=pondn]
rename bpl value

replace value=. if homeowner==0
summ value if homeowner==1
count if value==0 & homeowner==1
//0/1956
g noval = (value==0)
summ noval [aw=pond] if homeowner==1
drop noval
//0%

rename rmcap2 housing

keep year pondn age income homeow* value  hous*
save "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl2010", replace


////Creation final table
use "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1970", replace
append using "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1973"
append using "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1978"
append using "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1984"
append using "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1988"
append using "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1992"
append using "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl1996"
append using "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl2002"
append using "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl2006"
append using "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl2010"

//All amounts in current euros
summ income if year<2002
replace income=income/6.55957 if year<2002
summ income if year<2002

summ value if year<2002
replace value=value/6.55957 if year<2002
summ value if year<2002

rename income rev_tot
rename value patfon_owner
replace rev_tot=0 if rev_tot<0

tab year
/*     year |      Freq.     Percent        Cum.
------------+-----------------------------------
       1970 |     11,050        3.65        3.65
       1973 |     45,064       14.87       18.52
       1978 |     23,492        7.75       26.27
       1984 |     29,233        9.65       35.92
       1988 |     26,686        8.81       44.72
       1992 |     36,222       11.95       56.67
       1996 |     29,043        9.58       66.26
       2002 |     32,156       10.61       76.87
       2006 |     42,963       14.18       91.05
       2010 |     27,137        8.95      100.00
------------+-----------------------------------
      Total |    303,046      100.00
*/

//Retreatment for ages
replace age=20 if age<20 & inlist(year,1970,1978,1984,1988,1992,1996,2002,2006,2010)
replace age=20 if age>15 & age<20 & year==1973
replace age=age+100 if age<15 & year==1973
replace age=age-100 if age>150 & year==1978
tab age, missing

saveold "W:\brtrd\Enquete Logements\EnquetesLogements\homogenized tables\enl_1970_2010", replace

